class Mutator_DamageToScore extends Mutator config(Monsterhunt2);

var config int MonsterDamage;

var float Multiplier;

var bool Init;

function PostBeginPlay()
{
	if (Init)
		return;
	Init = True;

	Level.Game.RegisterDamageMutator(Self);

	log("Mutator_DamageToScore Initialized");

}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
local int MaxScore;

	if (InstigatedBy.IsA('ScriptedPawn') && Victim.IsA('ScriptetPawn'))
		{
		ActualDamage = 0;
		}
	
	else if (InstigatedBy.IsA('ScriptedPawn') && !Victim.IsA('ScriptetPawn'))
		{
		//log ("The monsters damage is defined to:"@ActualDamage);
		Multiplier = MonsterDamage / 100;
		ActualDamage *= Multiplier;
		if ( Victim.IsA('PlayerPawn') && Info_PRI(PlayerPawn(Victim).PlayerReplicationInfo).ReduceDamage > 0 )
			{
			ActualDamage *= 1 - (Info_PRI(PlayerPawn(Victim).PlayerReplicationInfo).ReduceDamage / 100);
			}
		//log ("The monsters damage has been set to:"@ActualDamage$" when multiplied with:"@Multiplier);
		}

	else if ( InstigatedBy.IsA('PlayerPawn') || InstigatedBy.IsA('Bot'))
     		{
		if ( InstigatedBy.IsA('PlayerPawn') )
			{
			ActualDamage = (Info_PRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).AddToDamage / 100 + 1) * ActualDamage;
			}

		if (Victim.IsA('ScriptedPawn'))
			{
			MaxScore = Victim.Health;
			if ( ActualDamage > MaxScore )
				{
				InstigatedBy.PlayerReplicationInfo.Score += MaxScore;
				}
			else
				{
				InstigatedBy.PlayerReplicationInfo.Score += ActualDamage;
				}	
			}
     		}

	if ( NextDamageMutator != None )
     		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

defaultproperties
{
}
